package edu.unl.consystlab.sudokuSolver.consistencyAlgorithms;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;
import edu.unl.consystlab.sudokuSolver.problemVariable;
import edu.unl.consystlab.sudokuSolver.sudokuBoard;

public class backCheckOnVariable extends consistencyAlgorithm {

	private problemVariable masterVariable;
	
	public backCheckOnVariable(constraintProblem newProblem, sudokuBoard board, problemVariable newMasterVariable) {
		super(newProblem, board);
		masterVariable = newMasterVariable;
	}
	
	//returns true if it doesn't hit an error,
	//returns false if it does encounter an error
	public boolean runAlgorithm()
	{
		variableReductions = new LinkedList();
		if(masterVariable.isAssigned())
		{
			Iterator i = masterVariable.getBinaryConstraints().iterator();
			while(i.hasNext())
			{
				problemConstraint currConstraint = (problemConstraint)i.next();
				if(((problemVariable)currConstraint.getScope().get(0)).isAssigned() &&
						((problemVariable)currConstraint.getScope().get(1)).isAssigned() &&
						((problemVariable)currConstraint.getScope().get(0)).getAssigned()
						.equals(((problemVariable)currConstraint.getScope().get(1)).getAssigned()))
				{
					//we have hit an error return
					setBrokenConstraint(currConstraint);
					setEncounteredError(true);
					return false;
				}
			}
		}
		setBrokenConstraint(null);
		setEncounteredError(false);
		return true;
	}
}
